/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.config;

import com.alexander.mutantmore.enums.CameraShakePriority;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ScreenShakingClientConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> allowed_screen_shake_priorities;
    public static final ForgeConfigSpec.ConfigValue<Float> screen_shake_amount;

    static {
        BUILDER.comment("Configure Mutant More's battle music on the client side (these changes will only affect you)! The client side needs to be reloaded by pressing F3 + T for changes to take effect!");
        allowed_screen_shake_priorities = BUILDER.comment("\n A list of allowed screen shake priorities:\n`effect` for screen shakes created purely for effect (like when a Fire Slash is passing by),\n`player_action` for meaningful actions that the player performs (like using a Blazing Scimitar to create a Fire Slash),\n`weak_mob_action` for actions performed by mobs that are meaningful but not extremely important (like the Mutant Wither Skeleton's basic attack)\nor `strong_mob_action` for important and meaningful actions performed by mobs (like the Mutant Wither Skeleton's strong attack or a mutant intro animation),\n usually set to `effect`, `player_action` and `strong_mob_action`").defineList("Allowed Screen Shake Priorities", (List)Lists.newArrayList((Object[])new String[]{"effect", "player_action", "strong_mob_action"}), o -> o instanceof String && CameraShakePriority.stringMatchesAnyPriority((String)o));
        screen_shake_amount = BUILDER.comment("\n The intensity of screen shakes\n usually set to 0.75").define("Screen Shake Intensity", (Object)Float.valueOf(0.75f));
        SPEC = BUILDER.build();
    }
}

